CREATE FUNCTION [dbo].[CFUJ_SCA_DatosAdicionales](@pJson VARCHAR(8000))
RETURNS VARCHAR(8000)
AS
BEGIN

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pId_Cliente		INT
DECLARE @pId_Evento			SMALLINT
DECLARE @pFecha				DATETIME

SET @pId_Cliente		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Evento			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Evento')), 0)
SET @pFecha				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), GETDATE())
/*FIN Variables recibidas por parametro a traves del JSON*/


/*Variables Locales*/
DECLARE @Datos_Adicionales_jSon		VARCHAR(8000)
DECLARE @Adic1_Texto				VARCHAR(1000)
DECLARE @Adic1_Fondo_Color_Hex			VARCHAR(6)
DECLARE @Adic1_Fuente_Color_Hex			VARCHAR(6)
DECLARE @Adic2_Texto				VARCHAR(1000)
DECLARE @Adic2_Fondo_Color			VARCHAR(6)
DECLARE @Adic2_Fuente_Color_Hex			VARCHAR(6)
DECLARE @Adic3_Texto				VARCHAR(1000)
DECLARE @Adic3_Fondo_Color			VARCHAR(6)
DECLARE @Adic3_Fuente_Color_Hex			VARCHAR(6)
/*FIN Variables Locales*/

/*Inicializacion*/
SET @Adic1_Texto				= ''
SET @Adic1_Fondo_Color_Hex		= 'FEFFFE'
SET @Adic1_Fuente_Color_Hex		= '292828'
SET @Adic2_Texto				= ''
SET @Adic2_Fondo_Color			= 'FEFFFE'
SET @Adic2_Fuente_Color_Hex		= '292828'
SET @Adic3_Texto				= ''
SET @Adic3_Fondo_Color			= 'FEFFFE'
SET @Adic3_Fuente_Color_Hex		= '292828'

/*-----------------------------------------------------------------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------------------------------------------------------------*/

/*IMPLEMENTAR*/
/*
EJ IMPLEMENTACION:

DECLARE @Id_Cliente_Externo			VARCHAR(14)
DECLARE @Razon_Social				VARCHAR(100)
DECLARE @Apellido					VARCHAR(100)
DECLARE @Nombre						VARCHAR(100)
DECLARE @Id_Tipo_Cli				SMALLINT
DECLARE @Categoria					VARCHAR(100)
DECLARE @Id_Cliente_Ref				INT
DECLARE @Doc_Nro					BIGINT
DECLARE @Fecha_Nac					DATETIME
DECLARE @Edad						SMALLINT
DECLARE @Ult_Cuota_Paga				DATETIME

DECLARE @Titular_Id_Cliente_Externo	VARCHAR(14)
DECLARE @Titular_Razon_Social		VARCHAR(100)
DECLARE @Titular_Apellido			VARCHAR(100)
DECLARE @Titular_Nombre				VARCHAR(100)
DECLARE @Titular_Id_Tipo_Cli		SMALLINT
DECLARE @Titular_Categoria			VARCHAR(100)
DECLARE @Titular_Doc_Nro			BIGINT
DECLARE @Titular_Fecha_Nac			DATETIME
DECLARE @Titular_Edad				SMALLINT
DECLARE @Titular_Ult_Cuota_Paga		DATETIME

SELECT 
@Id_Cliente_Externo				= ISNULL(CL.Id_Cliente_Externo, ''),
@Razon_Social					= UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '')))),
@Apellido						= UPPER(LTRIM(RTRIM(ISNULL(CL.Apellido, '')))),
@Nombre							= UPPER(LTRIM(RTRIM(ISNULL(CL.Nombre, '')))),
@Id_Tipo_Cli					= ISNULL(CL.Id_Tipo_Cli, 0),
@Categoria						= UPPER(LTRIM(RTRIM(ISNULL(CT.Descripcion, '')))),
@Id_Cliente_Ref					= ISNULL(CL.Id_Cliente_Ref, 0),
@Doc_Nro						= ISNULL(CL.Doc_Nro, 0),
@Fecha_Nac						= ISNULL(CL.Fecha_Nac, '19000101'),
@Edad							= dbo.CF_Edad_Persona_A_UnaFecha( ISNULL(CL.Fecha_Nac, '19000101'), @pFecha),
@Ult_Cuota_Paga					= ISNULL(CL.Ult_Cuota_Paga, '19000101')
FROM Clientes CL, Clientes_Tipos CT
WHERE
CL.Id_Tipo_Cli = CT.Id_Tipo_Cli
AND Id_Cliente = @pId_Cliente

IF(@Id_Cliente_Ref = 0)
BEGIN
	SET @Id_Cliente_Ref = @pId_Cliente
END

SELECT 
@Titular_Id_Cliente_Externo		= ISNULL(CL.Id_Cliente_Externo, ''),
@Titular_Razon_Social			= UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '')))),
@Titular_Apellido				= UPPER(LTRIM(RTRIM(ISNULL(CL.Apellido, '')))),
@Titular_Nombre					= UPPER(LTRIM(RTRIM(ISNULL(CL.Nombre, '')))),
@Titular_Id_Tipo_Cli			= ISNULL(CL.Id_Tipo_Cli, 0),
@Titular_Categoria				= UPPER(LTRIM(RTRIM(ISNULL(CT.Descripcion, '')))),
@Titular_Doc_Nro				= ISNULL(CL.Doc_Nro, 0),
@Titular_Fecha_Nac				= ISNULL(CL.Fecha_Nac, '19000101'),
@Titular_Edad					= dbo.CF_Edad_Persona_A_UnaFecha( ISNULL(CL.Fecha_Nac, '19000101'), @pFecha),
@Titular_Ult_Cuota_Paga			= ISNULL(CL.Ult_Cuota_Paga, '19000101')
FROM Clientes CL, Clientes_Tipos CT
WHERE
CL.Id_Tipo_Cli = CT.Id_Tipo_Cli
AND Id_Cliente = @Id_Cliente_Ref

---------------------------------------------------------------------------------------------------------------------------------------------

SET @Adic1_Texto	= 'CATEGORIA: ' + @Categoria

IF(@Titular_Id_Tipo_Cli = 1)
BEGIN
	SET @Adic1_Fondo_Color_Hex		= 'D8D62F'
END

---------------------------------------------------------------------------------------------------------------------------------------------

SET @Adic2_Texto	= 'EDAD: ' + CONVERT(VARCHAR(10), @Edad)

IF(@Edad < 10)
BEGIN
	SET @Adic2_Fuente_Color_Hex		= 'D8D62F'
END

---------------------------------------------------------------------------------------------------------------------------------------------

SET @Adic3_Texto	= 'TITULAR: ' + @Titular_Razon_Social
*/

/*-----------------------------------------------------------------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------------------------------------------------------------*/

/*Respuesta final*/
SET @Datos_Adicionales_jSon = '{' + 
								dbo.CF_Json_ParsearVariable('Adic1_Texto', @Adic1_Texto, 'VARCHAR(1000)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic1_Fondo_Color', @Adic1_Fondo_Color_Hex, 'VARCHAR(6)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic1_Fuente_Color', @Adic1_Fuente_Color_Hex, 'VARCHAR(6)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic2_Texto', @Adic2_Texto, 'VARCHAR(1000)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic2_Fondo_Color', @Adic2_Fondo_Color, 'VARCHAR(6)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic2_Fuente_Color', @Adic2_Fuente_Color_Hex, 'VARCHAR(6)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic3_Texto', @Adic3_Texto, 'VARCHAR(1000)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic3_Fondo_Color', @Adic3_Fondo_Color, 'VARCHAR(6)') + ',' +
								dbo.CF_Json_ParsearVariable('Adic3_Fuente_Color', @Adic3_Fuente_Color_Hex, 'VARCHAR(6)') +
								'}'

RETURN ISNULL(@Datos_Adicionales_jSon, '')
END

--SELECT dbo.CFUJ_SCA_DatosAdicionales]('{"Id_Cliente":"3893","Id_Evento":"0","Fecha":"2022-05-27T12:13:00"}')
